//
//  AppSettings.swift
//  Handy Harp Client
//  
//  Created by KIRA Ryouta on 2025/11/16.
//
/*
 MIT License

 Copyright (c) 2025-2026 PROCYON STUDIO CO., LTD.
 Copyright (c) 2025-2026 KIRA Ryouta

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

import CoreGraphics

enum AppType : Sendable {
    case sibelius
    case dorico

    static func forBundleIdentifier(bundleIdentifier: String) -> AppType? {
        switch bundleIdentifier {
        case "com.avid.sibelius":
            return .sibelius
        case "com.steinberg.dorico6", "com.steinberg.dorico7", "com.steinberg.dorico8", "com.steinberg.dorico9":
            return .dorico

        default:
            return nil
        }
    }

    func keyCommands(command: UInt32) -> KeySequence? {
        switch self {
        case .sibelius:
            if (command & 0xff000000) == 0x10000000 {
                var p: Int = Int(command)
                var keySequence: [KeySequence] = []
                keySequence.append(.single(key: .command_t))
                let funcPedal = { () -> KeySequence in
                    var ks: KeySequence
                    switch p & 3 {
                    case 0:
                        ks = .single(key: .command_option_keypad9)
                    case 1:
                        ks = .single(key: .command_option_keypad7)
                    case 2:
                        ks = .single(key: .command_option_keypad8)
                    default:
                        ks  = .single(key: .command_option_keypad8)
                    }
                    p >>= 2
                    return ks
                }
                keySequence.append(funcPedal())
                keySequence.append(funcPedal())
                keySequence.append(funcPedal())
                keySequence.append(.single(key: .command_option_keypadplus))
                keySequence.append(funcPedal())
                keySequence.append(funcPedal())
                keySequence.append(funcPedal())
                keySequence.append(funcPedal())
                keySequence.append(.single(key: .escape))
                keySequence.append(.single(key: .escape))
                return .multiple(keySequence)
            }
        case .dorico:
            if (command & 0xff000000) == 0x10000000 {
                var p: Int = Int(command)
                var keySequence: [KeySequence] = []
                keySequence.append(.single(key: .shift_p))
                let funcPedal = { () -> KeySequence? in
                    var ks: KeySequence
                    switch p & 3 {
                    case 0:
                        ks = .single(key: .string(text: "^"))
                    case 1:
                        ks = .single(key: .string(text: "-"))
                    case 2:
                        ks = .single(key: .string(text: "v"))
                    default:
                        return nil
                    }
                    p >>= 2
                    return ks
                }
                if let seq = funcPedal() {
                    keySequence.append(seq)
                }
                else {
                    return nil
                }
                if let seq = funcPedal() {
                    keySequence.append(seq)
                }
                else {
                    return nil
                }
                if let seq = funcPedal() {
                    keySequence.append(seq)
                }
                else {
                    return nil
                }
                if let seq = funcPedal() {
                    keySequence.append(seq)
                }
                else {
                    return nil
                }
                if let seq = funcPedal() {
                    keySequence.append(seq)
                }
                else {
                    return nil
                }
                if let seq = funcPedal() {
                    keySequence.append(seq)
                }
                else {
                    return nil
                }
                if let seq = funcPedal() {
                    keySequence.append(seq)
                }
                else {
                    return nil
                }
                keySequence.append(.single(key: .returnKey))
                return .multiple(keySequence)
            }
        }
        return nil
    }
}
